CREATE OR REPLACE PACKAGE BODY bank_context2_pkg IS

  -- Funkcia vrati, pre dany login klienta sol.
  FUNCTION get_client_salt(p_login IN client.login%TYPE) RETURN client.salt%TYPE IS
    l_return client.salt%TYPE;
  BEGIN
    -- zistime sol pre daneho zakaznika
    SELECT c.salt
    INTO   l_return
    FROM   client c
    WHERE  c.login = p_login;

    RETURN l_return;

    -- ak sa ucet neexistuje vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20666, 'No such client');
  END get_client_salt;

  --Funkcia vrati, pre dany login zamestnanca sol.
  FUNCTION get_employee_salt(p_login IN employee.login%TYPE) RETURN employee.salt%TYPE IS
    l_return client.salt%TYPE;
  BEGIN
    -- zistime sol pre daneho zamestnanca
    SELECT e.salt
    INTO   l_return
    FROM   employee e
    WHERE  e.login = p_login;

    RETURN l_return;

    -- ak sa ucet neexistuje vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20666, 'No such employee');
  END get_employee_salt;

  --- Funkcia nastavi kontext zakaznikovi
  PROCEDURE init_client_context(p_login    IN client.login%TYPE,
                                p_password IN client.password%TYPE) IS
    l_client_id client.client_id%TYPE;
  BEGIN
    -- overime ci exsistuje zakaznik s danym menom a heslom
    SELECT c.client_id
    INTO   l_client_id
    FROM   client c
    WHERE  c.login = p_login
    AND    c.password = p_password;

    -- cislo uctu nastavime na null
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => NULL);

    -- nastavime typ pouzivatela na CLIENT
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'user_type',
                             VALUE     => 'CLIENT');

    -- nastavime id klienta
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'client_id',
                             VALUE     => l_client_id);

    -- ak zadal klient nespravne heslo a meno vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20667, 'Authentication error');
  END init_client_context;

  -- inicializaca kontextu pre terminal
  PROCEDURE init_terminal_context(p_card_no IN card.card_no%TYPE,
                                  p_pin     IN card.pin%TYPE) IS
    l_account_no card.account_no%TYPE;
    l_client_id  account.client_id%TYPE;
  BEGIN
    SELECT c.account_no, c.client_id
    INTO   l_account_no, l_client_id
    FROM   card c
    WHERE  c.card_no = p_card_no
    AND    c.valid = 1
    AND    c.pin = p_pin;

    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'client_id',
                             VALUE     => l_client_id);

    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => l_account_no);

    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'user_type',
                             VALUE     => 'TERMINAL');

    -- ak terminal poslal nespravne cislo karty a pin, vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20667, 'Authentication error');
  END init_terminal_context;

  -- procedura nastavuje pre zakaznika cislo uctu v kontexte
  PROCEDURE set_client_account_no(p_account_no IN account.account_no%TYPE) IS
    l_client_id client.client_id%TYPE;
    l_dummy     VARCHAR2(1);
  BEGIN

    -- najprv musi byt nastavene id klienta az potom mozeme nastavit cislo uctu
    l_client_id := sys_context('bank_context2', 'client_id');

    IF l_client_id IS NULL THEN
      raise_application_error(-20670, 'Client id not set.');
    END IF;

    -- pozrieme sa ci ma zakaznik dane cislo uctu
    SELECT NULL
    INTO   l_dummy
    FROM   account a
    WHERE  a.client_id = l_client_id
    AND    a.account_no = p_account_no;

    -- ak ano nastavime ho
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => p_account_no);
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20668, 'No such account');
  END set_client_account_no;

  -- nastavenie kontextu pre zamestnanca
  PROCEDURE init_employee_context(p_login    IN employee.login%TYPE,
                                  p_password IN employee.password%TYPE) IS

    l_employee_type employee.emp_type%TYPE;
  BEGIN

    -- zistime ci sa existuje zamestnanec s danym menom a heslom
    SELECT e.emp_type
    INTO   l_employee_type
    FROM   employee e
    WHERE  e.login = p_login
    AND    e.password = p_password;

    -- ak ano mastavime typ pouzivatela na EMP
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'user_type',
                             VALUE     => 'EMP');

    -- nastavime id uctu na null
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'client_id',
                             VALUE     => NULL);

    -- nastavime id klienta na null
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => NULL);

    -- nastavime typ zamestnanca
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'employee_type',
                             VALUE     => l_employee_type);

  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20667, 'Authentication error');
  END init_employee_context;

  -- nastavuje id zakaznika pre zamestnanca
  PROCEDURE set_employee_client_id(p_client_id IN client.client_id%TYPE) IS
    l_emp_type employee.emp_type%TYPE;
    l_dummy    VARCHAR2(1);
  BEGIN
    -- pozrieme sa aky zamestnanec si chce nastavit id zakaznika
    l_emp_type := sys_context('bank_context2', 'employee_type');
    CASE
    --- ak je to CTELLER zistime ci je klient obycajny
      WHEN l_emp_type = 'CTELLER' THEN
        SELECT NULL
        INTO   l_dummy
        FROM   client c
        WHERE  c.client_id = p_client_id
        AND    c.client_type = 'COMMON';

    -- ak je BTELLR, zistime ci chce nastavit biznis klienta
      WHEN l_emp_type = 'BTELLER' THEN
        SELECT NULL
        INTO   l_dummy
        FROM   client c
        WHERE  c.client_id = p_client_id
        AND    c.client_type = 'B2B';
      ELSE
        raise_application_error(-20668, 'Not authenticated or unknown employee type.');
    END CASE;

    -- ak islo o spravny typ klienta nastavime prislusne polozky v kontexte.. cislo uctu na null
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => NULL);

    -- nastavime id klienta do kontextu
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'client_id',
                             VALUE     => p_client_id);

    -- ak to nebol spravny typ klienta vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20669, 'You are not authorized to operate with this client.');
  END set_employee_client_id;

  -- procedura pre zamestnanca nastavi cislo uctu
  PROCEDURE set_employye_account_no(p_account_no IN account.account_no%TYPE) IS
    l_client_id client.client_id%TYPE;
    l_dummy     VARCHAR2(1);
  BEGIN
    -- musi byt nastavene id klienta
    l_client_id := sys_context('bank_context2', 'client_id');

    IF l_client_id IS NULL THEN
      raise_application_error(-20670, 'Client id not set.');
    END IF;

    -- pokusime sa najst pre klienta v kontexte dany ucet
    SELECT NULL
    INTO   l_dummy
    FROM   account a
    WHERE  a.client_id = l_client_id
    AND    a.account_no = p_account_no;

    -- ak sa ucet nasiel nastavime ho v kontexte
    dbms_session.set_context(namespace => 'bank_context2',
                             attribute => 'account_no',
                             VALUE     => p_account_no);

    -- ak taky ucet klient z kontextu nema, vyhodime vynimku
  EXCEPTION
    WHEN no_data_found THEN
      raise_application_error(-20668, 'No such account');
  END set_employye_account_no;

END bank_context2_pkg;
/

